class ScatterPlotPoint {
  
  //Variables

  float sepal_length, sepal_width, petal_length, petal_width;
  String species;

  float xPos, yPos, size, orientation;
  color myColor;

  //Constructor
  ScatterPlotPoint (float sepal_length, float sepal_width, float petal_length, float petal_width, String species) {
    this.sepal_length = sepal_length;
    this.sepal_width = sepal_width;
    this.petal_length = petal_length;
    this.petal_width = petal_width;
    this.species = species;

    xPos = 10000;
    yPos = 10000;
    size = 10;
  }

  //Plot the points
  void plot(float xFilter, float yFilter) {
    float plotX = xPos*(800/xFilter)+75;
    float plotY = (height-50) - (yPos*(600/yFilter));

    fill(myColor, 50);
    noStroke();

    if ( (plotX >=75 && plotX <= 875) && (plotY >= 50 && plotY <= height-50)) {
      pushMatrix();
      translate (plotX, plotY);
      rotate(orientation);
      ellipse (0, 0, size, size*2);
      popMatrix();
    }
  }
  
  //Setters
  void setXPos (float value) {
    xPos = value;
  }

  void setYPos (float value) {
    yPos = value;
  }

  void setColor (color Color) {
    myColor = Color;
  }

  void setColor (float value) {
    if (value > 255) value = 255;
    myColor = color(value);
  }

  void setSize (float value) {
    size = value*3;
  }
  
  void setOrientation (float value) {
    orientation = value;  
  }
  
  
  //Getters
  float getSepal_length() {
    return sepal_length;
  }

  float getSepal_width() {
    return sepal_width;
  }

  float getPetal_length() {
    return petal_length;
  }

  float getPetal_width() {
    return petal_width;
  }

  String getSpecies() {
    return species;
  }
}

